import { NextRequest, NextResponse } from 'next/server';
import { sliderStore } from '@/lib/data-store';

export async function GET() {
  try {
    const sliders = await sliderStore.getAll();
    return NextResponse.json(sliders);
  } catch (error) {
    console.error('Error fetching sliders:', error);
    return NextResponse.json({ error: 'Failed to fetch sliders' }, { status: 500 });
  }
}

export async function POST(request: NextRequest) {
  try {
    const data = await request.json();
    const slider = await sliderStore.create(data);
    return NextResponse.json(slider);
  } catch (error) {
    console.error('Error creating slider:', error);
    return NextResponse.json({ error: 'Failed to create slider' }, { status: 500 });
  }
}